create procedure bi_mat_extract_pattern as 
CURSOR part_pattern is 
  SELECT PID,PATTERN,FID FROM BI_MAT_PATTERNS ORDER BY 1;

CURSOR part_group_list (pat varchar2) is
  SELECT distinct PART_GROUP FROM MAMA.T_MAT_DEF tmd where tmd.PART_GROUP like pat;

begin
  Execute immediate 'TRUNCATE TABLE BI_MAT_PART_GROUPS';
  
  FOR PP IN part_pattern LOOP
    FOR pgl in part_group_list(PP.PATTERN) LOOP
      INSERT /*+ APPEND */ INTO BI_MAT_PART_GROUPS (PART_GROUP,FID) VALUES (pgl.PART_GROUP, PP.FID);
    END LOOP;  
  END LOOP;
  commit;
end bi_mat_extract_pattern;
/

