create procedure CopyDocumentData(origin in number,machine in number,owner in varchar2) is
	cursor select_data(p1 in number) is select * from doc_path_data where machine_id = p1 order by path_id;
	selected_data doc_path_data%rowtype;
  max_id number;
  inherited number;
  type docdata is record
  (
    orig_id number,
    new_id number
  );
  type docdata_arr is table of docdata;
  doclist docdata_arr := docdata_arr();
begin
  delete from doc_path_data where machine_id = machine;
	select max(path_id) into max_id from doc_path_data;	
  open select_data(origin);
  loop
    fetch select_data into selected_data;
    exit when select_data%NOTFOUND;
    max_id:=max_id+1;
    inherited := null;
    doclist.extend(1);
    doclist(doclist.count).orig_id := selected_data.path_id;
    doclist(doclist.count).new_id := max_id;
    if selected_data.path_inheritance is not null then
      for j in 1..doclist.count loop
        if doclist(j).orig_id = selected_data.path_inheritance then          
          inherited := doclist(j).new_id;
          --exit;
        end if;
      end loop;
    end if;
    insert into doc_path_data values(max_id,machine,selected_data.path_name,inherited,selected_data.path,selected_data.extension_filter,selected_data.name_filter,owner);    
  end loop;  
  commit;
  close select_data;
  exception when others then    
    rollback;  
end;
/

