create PROCEDURE P_USK_TRANSFER 
(
  D_LAST_RUN_DAY IN DATE 
) AS 
BEGIN
INSERT INTO ORBANG_USK_DAILY_DATA_BACKUP
(
  SELECT /*+ INDEX (run PD_LFD_RUN_X4)*/
RUN.RUNID,
CASE
WHEN instr(TED.TXT_INFO,'house_id',1)>1 THEN substr(TED.TXT_INFO,instr(TED.TXT_INFO,'house_id',1)+9,22)
WHEN instr(TED.TXT_INFO,'uid_out',1)>0 THEN substr(TED.TXT_INFO,instr(TED.TXT_INFO,'uid_out',1)+8,22)
END as house_sn,
RUN.RUNID_TYPE,RUN.RUN_DATE,
PRP_VAR,
plb.BMT_NAME,
PRP_BEZ,
substr(runid,1,7),
CASE
WHEN instr(TED.TXT_INFO,'house_id',1)>1 THEN substr(substr(TED.TXT_INFO,instr(TED.TXT_INFO,'house_id',1)+9,21),2,7)
WHEN instr(TED.TXT_INFO,'uid_out',1)>0 THEN substr(substr(TED.TXT_INFO,instr(TED.TXT_INFO,'uid_out',1)+8,21),2,7)
END as house_typ,
substr(runid,8,5),
CASE
WHEN instr(TED.TXT_INFO,'house_id',1)>1 THEN substr(substr(TED.TXT_INFO,instr(TED.TXT_INFO,'house_id',1)+9,21),9,5)
WHEN instr(TED.TXT_INFO,'uid_out',1)>0 THEN substr(substr(TED.TXT_INFO,instr(TED.TXT_INFO,'uid_out',1)+8,21),9,5)
END as house_sup,
CASE
WHEN instr(TED.TXT_INFO,'house_id',1)>1 THEN substr(substr(TED.TXT_INFO,instr(TED.TXT_INFO,'house_id',1)+9,21),1,1)
WHEN instr(TED.TXT_INFO,'uid_out',1)>0 THEN substr(substr(TED.TXT_INFO,instr(TED.TXT_INFO,'uid_out',1)+8,21),1,1)
END as house_cav,
MRK_TXT,
'',
RUN.RUN_STATE
FROM EVAPROD.PD_LFD_RUN RUN
LEFT OUTER JOIN EVAPROD.PD_STM_PRP PRP
ON RUN.PRP_DATE_ID = PRP.PRP_DATE_ID
LEFT OUTER JOIN EVAPROD.PD_LFD_TED2 TED
on TED.RUN_SEQ_KEY = RUN.RUN_SEQ_KEY
and TED.RUN_KEY_PRT = RUN.RUN_KEY_PRT
LEFT OUTER JOIN EVAPROD.PD_STM_MRK MRK
on MRK.PRP_DATE_ID = RUN.PRP_DATE_ID
and MRK_NUM='$#0001'
LEFT OUTER JOIN EVAPROD.PD_LFD_MED2 MED
on MED.RUN_SEQ_KEY = RUN.RUN_SEQ_KEY
and MED.RUN_KEY_PRT = RUN.RUN_KEY_PRT
AND MRK.MRK_NUM = MED.MRK_NUM
AND MRK_BEZ = 'Pallet number (6 characteres)'
LEFT OUTER JOIN EVAPROD.PD_LFD_MXT2 MXT
on MXT.RUN_SEQ_KEY = RUN.RUN_SEQ_KEY
and MXT.RUN_KEY_PRT = RUN.RUN_KEY_PRT
and MXT.MRK_NUM =MRK.MRK_NUM
left outer join evaprod.PD_LFD_BMN plb
on RUN.bmt_dat_id = PLB.bmt_dat_id
WHERE RUNID_TYPE = 'ER100_SN'
AND RUN_DATE BETWEEN 
 D_LAST_RUN_DAY
and sysdate
AND PRP_VAR LIKE '%USK');
END P_USK_TRANSFER;
/

