create FUNCTION Unit_check (unit_id IN VARCHAR2, unit_id_in_type IN VARCHAR2) RETURN VARCHAR2
	IS
        unit_id_type  VARCHAR2(15);  -- default check SMT10       
	unit_info VARCHAR2(15);	-- return data
	orb_i	  NUMBER;       -- ORB  INSP
	orb_p     NUMBER;       -- ORB REP PASS number
	orb_m     NUMBER;       -- ORB (-)
        orb_a     NUMBER;       -- VISCOM AOI ANA number
	viscom_i  NUMBER;       -- VISCOM INSP
	viscom_p  NUMBER;       -- VISCOM REP PASS number
	viscom_m  NUMBER;       -- VISCOM (-)
        orb_name  VARCHAR(40);  -- ORB name


BEGIN   

    unit_id_type:=unit_id_in_type;
    
    IF unit_id_in_type='ER60_MB_SMT6' THEN
        unit_id_type:='ER60_MB';
    END IF;
    
    orb_name:='ORBSYMB';
    IF  unit_id_in_type='ER60_MB_SMT6' or unit_id_in_type='SC08_MB' or unit_id_in_type='SC06_MB' THEN
        orb_name:='ORBOTECH';
    END IF;
    
    IF unit_id_type='ER70_MB' or unit_id_in_type='ER60_MB_SMT6' or unit_id_in_type='SC08_MB' or unit_id_in_type='SC06_MB' or unit_id_in_type='ER25E_MB' or unit_id_in_type='LAMES_MB'  or unit_id_type='SAABD_MB' or unit_id_type='SC03_MB'THEN
        unit_info:= 'V++';	-- not mandantory
      ELSE
	-- VISCOM find
	select distinct count(plr.RUNID) INTO viscom_i from PD_LFD_RUN plr, PD_LFD_PAG plg where plr.RUNID=unit_id and plr.RUNID_TYPE=unit_id_type and plr.PRD_PAG_SID = plg.PRD_PAG_SID and plg.PRP_VAR='VISCOMBO' and plr.RUN_STATE='F';
	select distinct count(plr.RUNID) INTO viscom_p from PD_LFD_RUN plr, PD_LFD_PAG plg where plr.RUNID=unit_id and plr.RUNID_TYPE=unit_id_type and plr.PRD_PAG_SID = plg.PRD_PAG_SID and plg.PRP_VAR='VISCOMBO_REP' and plr.RUN_STATE='P';
	select distinct count(plr.RUNID) INTO viscom_m from PD_LFD_RUN plr, PD_LFD_PAG plg where plr.RUNID=unit_id and plr.RUNID_TYPE=unit_id_type and plr.PRD_PAG_SID = plg.PRD_PAG_SID and plg.PRP_VAR='VISCOMBO' and plr.RUN_STATE='-';      

	IF (viscom_m=0 and viscom_i=0) THEN
		unit_info:='VFF'; -- NOT VISCOM INSP, FAILD, FAILD
            ELSE
		IF viscom_m>0 THEN
                    unit_info:='V-P'; -- VISCOM FIRST PASS (-), PASS
		END IF;
		IF viscom_i>0 THEN
                      unit_info:='VI'; -- VISCOM INSP
                      IF viscom_p>0 THEN
                          unit_info:= unit_info || 'P'; -- VISCOM REP PASS
			ELSE
			  unit_info:= unit_info || 'F'; -- VISCOM NOT REP
                      END IF;
		END IF;
        END IF;
    END IF;
    -- ORBOTECH find
    IF unit_id_in_type <> 'ER70_MB' and unit_id_in_type<>'ER25E_MB' and unit_id_in_type<>'LAMES_MB' and unit_id_in_type<>'SAABD_MB' and unit_id_type<>'SC03_MB' THEN
      select distinct count(plr.RUNID) INTO orb_i from PD_LFD_RUN plr, PD_LFD_PAG plg where plr.RUNID=unit_id and plr.RUNID_TYPE=unit_id_type and plr.PRD_PAG_SID = plg.PRD_PAG_SID and plg.PRP_VAR=orb_name and plr.RUN_STATE='F';
      select distinct count(plr.RUNID) INTO orb_p from PD_LFD_RUN plr, PD_LFD_PAG plg where plr.RUNID=unit_id and plr.RUNID_TYPE=unit_id_type and plr.PRD_PAG_SID = plg.PRD_PAG_SID and plg.PRP_VAR=TO_CHAR(orb_name || '_REP') and plr.RUN_STATE='P';
      select distinct count(plr.RUNID) INTO orb_m from PD_LFD_RUN plr, PD_LFD_PAG plg where plr.RUNID=unit_id and plr.RUNID_TYPE=unit_id_type and plr.PRD_PAG_SID = plg.PRD_PAG_SID and plg.PRP_VAR=orb_name and plr.RUN_STATE='-';
	IF (orb_i=0 and orb_m=0) THEN
		unit_info:= unit_info || 'OFF'; -- NOT ORBOTECH INSP, FAILD, FAILD
	  ELSE
		IF orb_m>0 THEN
			unit_info:= unit_info || 'O-P'; -- ORBOTECH FIRST PASS (-), PASS
		END IF;
		IF orb_i>0 THEN
			unit_info:= unit_info || 'OI'; -- ORBOTECH INSP
			IF orb_p>0 THEN
				unit_info:= unit_info || 'P'; -- ORBOTECH REP PASS
			  ELSE
				unit_info:= unit_info || 'F'; -- ORBOTECH NOT REP
			END IF;
		END IF;
	END IF;
     ELSE
      orb_name:='VISCOMC';
      IF unit_id_in_type='LAMES_MB' THEN
          orb_name:='ORBOTECHC';
      END IF;
      select distinct count(plr.RUNID) INTO orb_i from PD_LFD_RUN plr, PD_LFD_PAG plg where plr.RUNID=unit_id and plr.RUNID_TYPE=unit_id_type and plr.PRD_PAG_SID = plg.PRD_PAG_SID and plg.PRP_VAR=orb_name and plr.RUN_STATE='F';
      select distinct count(plr.RUNID) INTO orb_p from PD_LFD_RUN plr, PD_LFD_PAG plg where plr.RUNID=unit_id and plr.RUNID_TYPE=unit_id_type and plr.PRD_PAG_SID = plg.PRD_PAG_SID and plg.PRP_VAR=TO_CHAR(orb_name || '_REP') and plr.RUN_STATE='P';
      select distinct count(plr.RUNID) INTO orb_a from PD_LFD_RUN plr, PD_LFD_PAG plg where plr.RUNID=unit_id and plr.RUNID_TYPE=unit_id_type and plr.PRD_PAG_SID = plg.PRD_PAG_SID and plg.PRP_VAR=TO_CHAR(orb_name || '_ANA') and plr.RUN_STATE='P';
      
      IF orb_i=0  THEN
            unit_info:= unit_info || 'OFF';
         ELSE
              IF orb_i>0 THEN
                  unit_info:= unit_info || 'OI'; -- VISCOM AOI INSP
                  IF orb_a>0 THEN
                      unit_info:= unit_info || 'P'; -- VISCOM AOI ALL FALSE CALL
                    ELSE
                      IF orb_p>0 THEN
                          unit_info:= unit_info || 'P'; -- VISCOM AOI REP PASS
                        ELSE
                          unit_info:= unit_info || 'F'; -- VISCOM AOI NOT REP
                      END IF;
                  END IF;
              END IF;
       END IF;
    END IF;
                  
          
     
   --DBMS_OUTPUT.PUT_LINE ('---------- START DEBUG ---------------');
   --DBMS_OUTPUT.PUT_LINE ( 'unit_id_type: ' || unit_id_type);
   --DBMS_OUTPUT.PUT_LINE ( 'unit_id_in_type: ' || unit_id_in_type);
   --DBMS_OUTPUT.PUT_LINE ( 'unit_id: ' || unit_id);
   --DBMS_OUTPUT.PUT_LINE ( 'orb_name: ' || orb_name);
   --DBMS_OUTPUT.PUT_LINE ( 'viscom_i: ' || viscom_i);
   --DBMS_OUTPUT.PUT_LINE ( 'viscom_p: ' || viscom_p);
   --DBMS_OUTPUT.PUT_LINE ( 'viscom_m: ' || viscom_m);
   --DBMS_OUTPUT.PUT_LINE ( 'orb_i: ' || orb_i);
   --DBMS_OUTPUT.PUT_LINE ( 'orb_p: ' || orb_p);
   --DBMS_OUTPUT.PUT_LINE ( 'orb_m: ' || orb_m); 
   --DBMS_OUTPUT.PUT_LINE ( 'orb_a: ' || orb_a);
   --DBMS_OUTPUT.PUT_LINE ( 'unit_info: ' || unit_info);
   --DBMS_OUTPUT.PUT_LINE ( '----------- DEBUG END ----------------');
  
    RETURN unit_info;
END Unit_check;

-- Author: Gergely Feith
-- Email: Gergely.Feith@contiautomotive.com
/

