create view AUTO_SCRAP_6_FAILS as
SELECT twsl.unit_id_in_type unit_id_type,
    twsl.unit_id_in unit_id,
    2 AS code,
    COUNT(qty_fail) numlastfails
  FROM t_wip_subset_log twsl,
    (SELECT unit_id_in,
      unit_id_in_type,
      job,
      process_step_id
    FROM t_wip_subset
    WHERE qty_fail > 0
    AND updated    < sysdate-1/24
    ) failunits
  WHERE twsl.unit_id_in        = failunits.unit_id_in
  AND twsl.unit_id_in_type     = failunits.unit_id_in_type
  AND twsl.src_job             = failunits.job
  AND twsl.src_process_step_id = failunits.process_step_id
  AND twsl.transaction_type   IN ('checkout', 'progress','checkin_checkout','start_checkout')
  AND twsl.src_job NOT LIKE 'GS%'
  AND twsl.src_job NOT LIKE 'T%'
  AND twsl.src_job NOT LIKE 'Q%'
  GROUP BY twsl.unit_id_in,
    twsl.unit_id_in_type,
    failunits.process_step_id
  HAVING COUNT(qty_fail) >= 6
  ORDER BY failunits.process_step_id
/

