create view MPM_VW_ANALYSIS_HIEARCHY as
SELECT 
  tch.CACHE_ID,
  tch.CACHE_NAME,
  level4.FOLDER_ID as lvl4_FOLDER_ID,
  level4.FOLDER_NAME as lvl4_FOLDER_NAME,
  COALESCE(level3.FOLDER_ID,level4.FOLDER_ID) as lvl3_FOLDER_ID,
  COALESCE(level3.FOLDER_NAME,level4.FOLDER_NAME) as lvl3_FOLDER_NAME,
  COALESCE(level2.FOLDER_ID,level3.FOLDER_ID,level4.FOLDER_ID) as lvl2_FOLDER_ID,
  COALESCE(level2.FOLDER_NAME,level3.FOLDER_NAME,level4.FOLDER_NAME) as lvl2_FOLDER_NAME,
  COALESCE(level1.FOLDER_ID,level2.FOLDER_ID,level3.FOLDER_ID,level4.FOLDER_ID) as lvl1_FOLDER_ID,
  COALESCE(level1.FOLDER_NAME,level2.FOLDER_NAME,level3.FOLDER_NAME,level4.FOLDER_NAME) as lvl1_FOLDER_NAME,
  COALESCE(level0.FOLDER_ID,level1.FOLDER_ID,level2.FOLDER_ID,level3.FOLDER_ID,level4.FOLDER_ID) as lvl0_FOLDER_ID,
  COALESCE(level0.FOLDER_NAME,level1.FOLDER_NAME,level2.FOLDER_NAME,level3.FOLDER_NAME,level4.FOLDER_NAME) as lvl0_FOLDER_NAME
FROM 
          MPM.T_FOLDER level4
LEFT JOIN MPM.T_FOLDER level3 ON level4.PARENT_FOLDER_ID=level3.FOLDER_ID
LEFT JOIN MPM.T_FOLDER level2 ON level3.PARENT_FOLDER_ID=level2.FOLDER_ID
LEFT JOIN MPM.T_FOLDER level1 ON level2.PARENT_FOLDER_ID=level1.FOLDER_ID
LEFT JOIN MPM.T_FOLDER level0 ON level1.PARENT_FOLDER_ID=level0.FOLDER_ID
LEFT JOIN (SELECT FOLDER_ID,CACHE_ID,CACHE_NAME FROM MPM.T_CACHE_HEAD UNION ALL SELECT FOLDER_ID,CACHE_ID,CACHE_NAME FROM MPM.T_CACHE_HEAD_HIS) tch on  level4.FOLDER_ID = tch.FOLDER_ID

WHERE --level4.FOLDER_TYPE='B' and
  (level0.PARENT_FOLDER_ID <=0  or level0.PARENT_FOLDER_ID is null) WITH READ ONLY
/

