create view MPM_VW_SAMPLE_VIOL_CACHE as
SELECT 
  tsv.sample_id,
  tch.CACHE_ID,
  tsv.RULE_ID,
  tcs.SAMPLE_DATE                                   AS SAMPLE_DATE,
  tsv.COMMENT_DATE                                  AS COMMENT_DATE,
  ROUND((tsv.COMMENT_DATE-tcs.SAMPLE_DATE)*24*60,2) AS VIOLATION_DELTA,
  tsv.VIOL_COMMENT,
  tsv.free_text,
  tsv.UPDATED_BY AS "OPERATOR"
FROM
  (SELECT   tsv.cache_id,
    tsv.sample_id,
    tsv.RULE_ID,
    tsv.COMMENT_DATE,
    tsv.viol_comment,
    tsv.free_text,
    tsv.UPDATED_BY
  FROM mpm.T_SAMPLE_VIOL tsv
  WHERE (tsv.viol_comment IS NOT NULL OR tsv.free_text IS NOT NULL)
  UNION ALL
  SELECT tsv.cache_id,
    tsv.sample_id,
    tsv.RULE_ID,
    tsv.COMMENT_DATE,
    tsv.viol_comment,
    tsv.free_text,
    tsv.UPDATED_BY
  FROM mpm.T_SAMPLE_VIOL_his tsv 
  WHERE (tsv.viol_comment IS NOT NULL OR tsv.free_text IS NOT NULL)
  ) tsv 
  join (SELECT tch.CACHE_ID FROM mpm.T_cache_head tch
  UNION ALL
  SELECT tch.CACHE_ID FROM mpm.T_cache_head_his tch
  ) tch on tsv.cache_id     = tch.cache_id
  join (SELECT tcs.SAMPLE_DATE, tcs.sample_id FROM mpm.t_cache_sample tcs
  UNION ALL
  SELECT tcs.SAMPLE_DATE, tcs.sample_id FROM mpm.t_cache_sample_his tcs
  ) tcs on tcs.sample_id      =tsv.sample_id
/

comment on table MPM_VW_SAMPLE_VIOL_CACHE is 'Commented SAMPLE_VIOL'
/

