create view V_F_PULSE_COMMENT as
select RU_ID, COMPLET_NAME, STATENAME, INTERPRETATION, USR_COMMENT_TSA USR_COMMENT, sum(STATE_DURATION) STATE_DURATION, SHIFT_DAY SHIFT_DAY_DATE, to_char(SHIFT_DAY, 'yyyy/mm/dd') SHIFT_DAY, SHIFT_TYPE
from
(select RU_ID, COMPLET_NAME, STATENAME, INTERPRETATION, USR_COMMENT_TSA, STATE_DURATION, STATE_START, STATE_END,
case 
  when (to_char(STATE_START, 'HH24') >= '06' and to_char(STATE_START, 'HH24') <= '23' ) then STATE_START 
  when (to_char(STATE_START, 'HH24') >= '00' and to_char(STATE_START, 'HH24') <= '05' ) then STATE_START-1
end SHIFT_DAY,
case 
  when (to_char(STATE_START, 'HH24') >= '06' and to_char(STATE_START, 'HH24') <= '17' ) then 'DE' 
  when (to_char(STATE_START, 'HH24') >= '18' or to_char(STATE_START, 'HH24') <= '05' ) then 'EJ'
end SHIFT_TYPE
from(
select stops.RU_ID, prop.COMPLET_NAME, stops.STATENAME, stops.INTERPRETATION, stops.USR_COMMENT_TSA, stops.STATE_DURATION, stops.STATE_START, stops.STATE_END from (
select STATENAME, RU_ID, USR_COMMENT_TSA, sum(STATE_END_GMT - STATE_START_GMT) AS STATE_DURATION, INTERPRETATION, STATE_START, STATE_END
from (select cor.STATENAME, cor.RU_ID, cor.USR_COMMENT_TSA, cor.STATE_START_GMT, cor.STATE_END_GMT, cor.STATE_START, cor.STATE_END, sta.INTERPRETATION
from PULSE.T_ETM_TIME_COR_HIST cor, PULSE.T_FL_STATE_OBJ sta    
where sta.STATENAME = cor.STATENAME     
and cor.STATE_START < (sysdate-0) AND cor.STATE_END > (sysdate-60)
union all
select cor.STATENAME, cor.RU_ID, cor.USR_COMMENT_TSA, cor.STATE_START_GMT, cor.STATE_END_GMT, cor.STATE_START, cor.STATE_END, sta.INTERPRETATION
from PULSE.T_ETM_TIME_COR cor, PULSE.T_FL_STATE_OBJ sta    
where sta.STATENAME = cor.STATENAME     
and cor.STATE_START < (sysdate-0) AND cor.STATE_END > (sysdate-730)   
) group by STATENAME, RU_ID,    USR_COMMENT_TSA,    INTERPRETATION,    STATE_START,    STATE_END  order by STATENAME
) stops
inner join PULSE.T_FL_RU_PROPERTIES prop
on stops.RU_ID = prop.RU_ID
order by STATE_START
))
group by to_char(SHIFT_DAY, 'yyyy/mm/dd'), SHIFT_DAY, RU_ID, COMPLET_NAME, STATENAME, INTERPRETATION, USR_COMMENT_TSA, SHIFT_TYPE
/

