create view V_F_PULSE_TO_JIRA as
select t1.COMPLET_NAME, t1.STATENAME, t1.STATE_DURATION STATENAME_DURATION, t2.USR_COMMENT, t2.STATE_DURATION from (
select * from (
SELECT 
  COMPLET_NAME,
  STATENAME,
  round(sum (STATE_DURATION)/60, 0) STATE_DURATION
FROM V_F_PULSE_COMMENT
where RU_ID in (36663, 39282)
and SHIFT_DAY = to_char(sysdate-1, 'YYYY/MM/DD')
and INTERPRETATION = 'Unplanned'
group by COMPLET_NAME, STATENAME)
where STATE_DURATION > 60) t1
inner join
(
SELECT RU_ID,
  COMPLET_NAME,
  STATENAME,
  INTERPRETATION,
  USR_COMMENT,
  round(sum(STATE_DURATION)/60, 0) STATE_DURATION
FROM V_F_PULSE_COMMENT
where RU_ID in (36663, 39282)
and SHIFT_DAY = to_char(sysdate-1, 'YYYY/MM/DD')
group by RU_ID, COMPLET_NAME, STATENAME, INTERPRETATION, USR_COMMENT
) t2
on t1.COMPLET_NAME = t2.COMPLET_NAME and t1.STATENAME = t2.STATENAME
/

