create view V_HKMC_ALLFAILSTEPS_NOW as
SELECT
    run.runid         AS runid,
    run.runid_type    AS runid_type,
    run.run_date      AS rundate,
    run.run_state     AS teszteredmeny,
    med.mrk_wert      AS ertek,
    med.mrk_ein_gut   AS tesztlepeseredmeny,
    pag.prp_var       AS testplan_name,
    sprp.prp_bez      AS material,
    smrk.mrk_bez      AS step_name,
    med.mrk_num       AS step_id,
    bmn.bmt_name      AS station_id
FROM
    pd_lfd_run    run,
    pd_lfd_med2   med,
    pd_stm_prp    sprp,
    pd_stm_mrk    smrk,
    pd_lfd_bmn    bmn,
    pd_lfd_pag PAG
WHERE
    smrk.prp_date_id = sprp.prp_date_id
    AND run.run_key_prt = med.run_key_prt -- ez uj
    AND run.run_seq_key = med.run_seq_key
    AND smrk.mrk_num = med.mrk_num
    AND run.prp_date_id = smrk.prp_date_id
    AND run.prp_date_id = sprp.prp_date_id
    AND bmn.bmt_dat_id = run.bmt_dat_id
    AND run.prd_pag_sid = pag.prd_pag_sid
    AND run.runid IN (
        SELECT
            runid
        FROM
            (
                SELECT
                    runid,
                    MAX(run_date) rundate
                FROM
                    (
                        SELECT
                            run.runid,
                            run.runid_type,
                            run.run_date
                        FROM
                            pd_lfd_run   run,
                            pd_lfd_pag   pag
                        WHERE
                            run.prd_pag_sid = pag.prd_pag_sid
                            AND run.runid IN (
                                SELECT
                                    tws.unit_id_in
                                FROM
                                    t_wip_subset tws
                                WHERE
                                    tws.unit_id_in_type IN (
                                        'HKMC_MB',
                                        'HKMC_SN'
                                    )
                                    AND tws.qty_fail = '1'
                                    AND tws.equipment IN (
                                        'ICH_UFPH',
                                        'ICH_UFUD',
                                        'ICHUFAOI',
                                        'ICHUFOVN',
                                        'ICHUFBUF',
                                        'ICH_UFSI',
                                        'ICHC1COA',
                                        'ICHC1AOI',
                                        'ICHC1OVN',
                                        'ICH_ICT',
                                        'ICH_UPS'
                                    )
                            )
                            AND run.runid_type IN (
                                'HKMC_SN',
                                'HKMC_MB'
                            )
                            AND pag.prp_var IN (
                                'HKMC_UNDERFILL_AOI',
                                'HKMC_SHIELD',
                                'HKMC_ICT',
                                'HKMC_UPS',
                                'HKMC_COATING_AOI',
                                'HKMC_DISP',
                                'HKMC_DISPAOI',
                                'HKMC_RF',
                                'HKMC_NRF'
                            )
                            AND run.run_state = 'F'
                    )
                GROUP BY
                    runid
            )
    )
    AND run.runid_type IN (
        'HKMC_SN',
        'HKMC_MB'
    )
    AND pag.prp_var IN (
        'HKMC_UNDERFILL_AOI',
        'HKMC_SHIELD',
        'HKMC_ICT',
        'HKMC_UPS',
        'HKMC_COATING_AOI',
        'HKMC_DISP',
        'HKMC_DISPAOI',
        'HKMC_RF',
        'HKMC_NRF'
    )
    AND run.run_state = 'F'
    AND med.mrk_ein_gut = 'F'
    AND run.run_date IN (
        SELECT
            rundate
        FROM
            (
                SELECT
                    runid,
                    MAX(run_date) rundate
                FROM
                    (
                        SELECT
                            run.runid,
                            run.runid_type,
                            run.run_date
                        FROM
                            pd_lfd_run   run,
                            pd_lfd_pag   pag
                        WHERE
                            run.prd_pag_sid = pag.prd_pag_sid
                            AND run.runid IN (
                                SELECT
                                    tws.unit_id_in
                                FROM
                                    t_wip_subset tws
                                WHERE
                                    tws.unit_id_in_type IN (
                                        'HKMC_MB',
                                        'HKMC_SN'
                                    )
                                    AND tws.qty_fail = '1'
                                    AND tws.equipment IN (
                                        'ICH_UFPH',
                                        'ICH_UFUD',
                                        'ICHUFAOI',
                                        'ICHUFOVN',
                                        'ICHUFBUF',
                                        'ICH_UFSI',
                                        'ICHC1COA',
                                        'ICHC1AOI',
                                        'ICHC1OVN',
                                        'ICH_ICT',
                                        'ICH_UPS'
                                    )
                            )
                            AND run.runid_type IN (
                                'HKMC_SN',
                                'HKMC_MB'
                            )
                            AND pag.prp_var IN (
                                'HKMC_UNDERFILL_AOI',
                                'HKMC_SHIELD',
                                'HKMC_ICT',
                                'HKMC_UPS',
                                'HKMC_COATING_AOI',
                                'HKMC_DISP',
                                'HKMC_DISPAOI',
                                'HKMC_RF',
                                'HKMC_NRF'
                            )
                            AND run.run_state = 'F'
                    )
                GROUP BY
                    runid
            )
    )
/

comment on table V_HKMC_ALLFAILSTEPS_NOW is 'Kalmár Gerg¿nek

Krisz'
/

