create view V_KRISZ_TEST as
SELECT
  psap.aslp_kom as csoport,
  COUNT(psap.aslp_kom) as darabszam
FROM 
  pd_lfd_run run,
  pd_lfd_med2 med,
  PD_STM_PRP sprp,
  pd_stm_mrk smrk,
  PD_LFD_PAG PAG,
  PD_LFD_TED2 ted2,
  PD_STM_ASLP psap,
  PD_STM_ASL psa
WHERE 
  smrk.prp_date_id = sprp.prp_date_id
  and RUN.run_key_prt     = med.run_key_prt
  AND run.run_seq_key     = med.run_seq_key
  AND smrk.mrk_num        = med.mrk_num
  AND run.prp_date_id     = smrk.prp_date_id
  and run.prp_date_id     = sprp.prp_date_id
  and RUN.PRD_PAG_SID     = PAG.PRD_PAG_SID
  AND RUN.run_key_prt = ted2.RUN_KEY_PRT
  AND run.run_seq_key = ted2.RUN_SEQ_KEY
  and psa.PRP_DATE_ID = smrk.prp_date_id
  and sprp.PRP_DATE_ID = psa.PRP_DATE_ID
  and psa.asl_date_id = psap.asl_date_id
  and med.mrk_wert = psap.aslp_num
  and med.mrk_num = psa.ASL_NAME
  and PAG.PRP_VAR in ('BE_ANA_HU_2')
  and med.mrk_num in ('RECOG')
  and ted2.TXT_INFO like '#user name: kocsiskne%'
  and run.run_date BETWEEN to_date('2021.11.23 00:00:01', 'YYYY-MM-DD HH24-MI-SS') AND 
                           to_date('2021.11.23 23:59:59', 'YYYY-MM-DD HH24-MI-SS')
group by psap.aslp_kom
ORDER BY psap.aslp_kom
/

